//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "td5_Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
TForm1::cBackground::cBackground()
{
        nGroundPoints = 50;
        groundBase = 0.1;
        groundSmoother = 5;
        ground = 0;
        mountainFactor = 0;
        init(nGroundPoints, groundBase, groundSmoother);
}
TForm1::cBackground::~cBackground()
{
        delete [] ground;
}
void TForm1::cBackground::init()
{
        init(nGroundPoints, groundBase, groundSmoother);
}
void TForm1::cBackground::init(int anGroundPoints, float agroundBase, int agroundSmoother)
{
        nGroundPoints = anGroundPoints;
        groundBase = agroundBase;
        groundSmoother = agroundSmoother;
        delete [] ground;
        ground = new float[nGroundPoints];
        // initial ground points
        int
                hi = nGroundPoints / 2;
        for (int i = 0; i < nGroundPoints; i++)
        {
                float
                        d = 2 * (float)abs(hi - i) / (float)nGroundPoints;
                d = mountainFactor * d + (1 - mountainFactor) * 0.8;
                ground[i] = groundBase + (1.0 - d) * (0.8 - groundBase) * (0.3 + (float)(rand() % 7) / 10.0);
        }
        // smoothed ground points
        for (int i = 0; i < nGroundPoints; i++)
        {
                float
                        sm = 0;
                for (int j = 0; j < groundSmoother; j++)
                {
                        int
                                k = i + j;
                        if (k < 0) k = 0;
                        if (k >= nGroundPoints) k = nGroundPoints - 1;
                        sm += ground[k] / groundSmoother;
                }
                ground[i] = sm;
        }
}
void TForm1::cBackground::draw(TImage * & image, float angleX)
{
        float
                dx = cos(angleX) * (float)image->Width * 50.0 / 49.0,
                dy = (float)image->Height;
        int
                start = (1 - cos(angleX)) * image->Width / 2;
        image->Canvas->Pen->Color = clYellow;
        image->Canvas->Pen->Width = 5 * image->Canvas->Pen->Width;
        image->Canvas->MoveTo(start, image->Height - dy * ground[0]);
        for (int i = 1; i < nGroundPoints; i++)
        {
                float
                        x = (float)i / (float)nGroundPoints;
                image->Canvas->LineTo(start + dx * x, image->Height - dy * ground[i]);
        }
        image->Canvas->Pen->Width = 0.2 * image->Canvas->Pen->Width;
//        image->Canvas->Brush->Color = clYellow;
//        image->Canvas->FloodFill(image->Width - 1, image->Height - 1, clWhite, fsSurface);
}
int TForm1::cBackground::getGroundIndex(float x)
{
        int
                fx = (int)(x * (float)nGroundPoints);
        if (fx == nGroundPoints) fx = nGroundPoints - 1;
        return fx;
}
//---------------------------------------------------------------------------
TForm1::cFigure::cFigure()
{
        x = (float)(rand() % 20) / 20.0;
        y = 1;
        w = 0.05;
        h = 0.1;
        forceX = 0;
        forceY = 0;
        moveStart = 1;
        jumpStart = 3;
        init(0, x, y);
}
TForm1::cFigure::~cFigure()
{
}
void TForm1::cFigure::init(int afignr, float ax, float ay)
{
        fignr = afignr;
        health = 10;
        x = ax;
        y = ay;
}
void TForm1::cFigure::draw(TImage * & image, float angleX)
{
        float
                dx = cos(angleX) * (float)image->Width * 50.0 / 49.0,
                dy = (float)image->Height;
        int
                start = (1 - cos(angleX)) * image->Width / 2;
        // number
        image->Canvas->Pen->Color = clBlack;
        image->Canvas->Brush->Color = clWhite;
        image->Canvas->TextOut(start + dx * x, image->Height - dy * (y + 2 * h), IntToStr(fignr) + ": " + IntToStr(health));
        // outline
        image->Canvas->Pen->Color = clBlack;
        image->Canvas->Brush->Color = clWhite;
//        image->Canvas->Rectangle(Rect(dx * x, image->Height - dy * (y + h),
//                dx * (x + w), image->Height - dy * y));
        // body
        float
                bodyx = x + w / 3,
                bodyy = y + 0.5 * h;
        if (fignr > 1)
        {
                image->Canvas->Brush->Color = clFuchsia;
                image->Canvas->Pen->Color = clBlack;
                image->Canvas->Ellipse(Rect(start + dx * bodyx, image->Height - dy * bodyy,
                        start + dx * (bodyx + w / 3), image->Height - dy * y));
                image->Canvas->Pen->Color = clWhite;
                image->Canvas->Pen->Width = 6 * image->Canvas->Pen->Width;
                image->Canvas->MoveTo(start + dx * bodyx, image->Height - dy * bodyy + dy * h / 4.0);
                image->Canvas->LineTo(start + dx * bodyx + dx * w / 6, image->Height - dy * bodyy + dy * h / 3.0);
                image->Canvas->LineTo(start + dx * bodyx + dx * w / 3, image->Height - dy * bodyy + dy * h / 4.0);
                image->Canvas->MoveTo(start + dx * bodyx + dx * w / 6, image->Height - dy * bodyy + dy * h / 4.0);
                image->Canvas->Pen->Width = image->Canvas->Pen->Width / 2;
                image->Canvas->LineTo(start + dx * bodyx + dx * w / 6, image->Height - dy * y);
                image->Canvas->Pen->Width = image->Canvas->Pen->Width / 3;
        }
        else
        {
                image->Canvas->Brush->Color = clWhite;
                image->Canvas->Pen->Color = clBlack;
                image->Canvas->Ellipse(Rect(start + dx * bodyx, image->Height - dy * bodyy,
                        start + dx * (bodyx + w / 3), image->Height - dy * y));
                image->Canvas->Pen->Color = clGray;
                image->Canvas->Pen->Width = 6 * image->Canvas->Pen->Width;
                image->Canvas->MoveTo(start + dx * bodyx, image->Height - dy * bodyy + dy * h / 4.0);
                image->Canvas->LineTo(start + dx * bodyx + dx * w / 6, image->Height - dy * bodyy + dy * h / 3.0);
                image->Canvas->LineTo(start + dx * bodyx + dx * w / 3, image->Height - dy * bodyy + dy * h / 4.0);
                image->Canvas->MoveTo(start + dx * bodyx + dx * w / 6, image->Height - dy * bodyy + dy * h / 4.0);
                image->Canvas->Pen->Width = image->Canvas->Pen->Width / 2;
                image->Canvas->LineTo(start + dx * bodyx + dx * w / 6, image->Height - dy * y);
                image->Canvas->Pen->Width = image->Canvas->Pen->Width / 3;
        }
        if (fignr > 1)
        {
                image->Canvas->Pen->Color = clYellow;
                image->Canvas->Brush->Color = clBlack;
        }
        else
        {
                image->Canvas->Pen->Color = clBlack;
                image->Canvas->Brush->Color = clYellow;
        }
        // head
        if (fignr > 1)
        {
                image->Canvas->Pen->Color = clBlack;
                image->Canvas->Brush->Color = clFuchsia;
        }
        else
        {
                image->Canvas->Pen->Color = clBlack;
                image->Canvas->Brush->Color = clWhite;
        }
        float
                headx = x,
                heady = y + h,
//                headr = 0.5 * h;
                headr = 0.5 * h;
        image->Canvas->Ellipse(Rect(start + dx * headx, image->Height - dy * heady,
                start + dx * (headx + headr), image->Height - dy * (heady - headr)));
        if (health <= 0)
        {
                image->Canvas->Pen->Color = clWhite;
                image->Canvas->Brush->Color = clWhite;
                image->Canvas->FillRect(Rect(start + dx * headx, image->Height - dy * heady,
                        start + dx * (headx + headr), image->Height - dy * (heady - headr / 2)));
                image->Canvas->Pen->Color = clRed;
                image->Canvas->Brush->Color = clRed;
                image->Canvas->FillRect(Rect(start + dx * headx, image->Height - dy * (heady - headr / 2 + headr / 7),
                        start + dx * (headx + headr), image->Height - dy * (heady - headr / 2)));
        }
        // eyes
        if (cos(angleX) > 0)
        {
        if (fignr > 1)
        {
                image->Canvas->Pen->Color = clBlue;
                image->Canvas->Brush->Color = clWhite;
        }
        else
        {
                image->Canvas->Pen->Color = clBlack;
                image->Canvas->Brush->Color = clWhite;
        }
        float
                eyexL = x + w / 4,
                eyexR = x + 3 * w / 4,
                eyey = y + h - headr / 2 - headr / 8,
                eyeR = headr / 2;
        image->Canvas->Ellipse(Rect(start + dx * (eyexL - eyeR / 3), image->Height - dy * (eyey + eyeR / 2),
                start + dx * (eyexL + eyeR / 3), image->Height - dy * (eyey - eyeR / 2)));
        image->Canvas->Ellipse(Rect(start + dx * (eyexR - eyeR / 3), image->Height - dy * (eyey + eyeR / 2),
                start + dx * (eyexR + eyeR / 3), image->Height - dy * (eyey - eyeR / 2)));
        image->Canvas->Brush->Color = clBlack;
        if (forceX > 0.1)
        {
                eyexL += eyeR / 4;
                eyexR += eyeR / 4;
        }
        else if (forceX < -0.1)
        {
                eyexL -= eyeR / 4;
                eyexR -= eyeR / 4;
        }
        eyeR = eyeR / 4;
        image->Canvas->Ellipse(Rect(start + dx * (eyexL - eyeR / 3), image->Height - dy * (eyey + eyeR / 2),
                start + dx * (eyexL + eyeR / 3), image->Height - dy * (eyey - eyeR / 2)));
        image->Canvas->Ellipse(Rect(start + dx * (eyexR - eyeR / 3), image->Height - dy * (eyey + eyeR / 2),
                start + dx * (eyexR + eyeR / 3), image->Height - dy * (eyey - eyeR / 2)));
        }
}
void TForm1::cFigure::update(cBackground * & background, cPhysics * & physics, float timeStep)
{
        // position
        int
                fx = background->getGroundIndex(x + w / 2);
        // x
        forceX = 0.9 * forceX;
        if (fabs(forceX) < 0.01)
        {
                forceX = 0;
        }
        x += forceX * timeStep / 1000.0;
        if (x < 0) x = 0;
        if (x > 1 - 2 * w) x = 1 - 2 * w;
        // y
        y += forceY * timeStep / 1000.0;
        if (y < background->ground[fx])
        {
                forceY = 0;
                y = background->ground[fx];
        }
        forceY -= physics->gravity;
}
void TForm1::cFigure::jump(cBackground * & background)
{
        int
                fx = background->getGroundIndex(x + w / 2);
        if (y == background->ground[fx])
        {
                forceY += jumpStart;
        }
}
void TForm1::cFigure::move(bool right)
{
        if (fabs(forceX) > 0.25 * moveStart)
        {
                return;
        }
        float
                move = moveStart;
        if (!right)
        {
                move *= -1;
        }
        forceX += move;
}
//---------------------------------------------------------------------------
TForm1::cGlob::cGlob()
{
        init();
}
TForm1::cGlob::~cGlob()
{
}
void TForm1::cGlob::init()
{
        globbing = false;
        r = 0.005;
        x = 0;
        y = 0;
        dx = 1;
        spitForce = 1.5;
        forceX = 0;
        forceY = 0;
}
void TForm1::cGlob::spit(bool right, float movementX, float movementY, float ax, float ay)
{
        globbing = true;
        x = ax;
        y = ay;
        if (right) dx = -1;
        else dx = 1;
        forceX = dx * (spitForce - 0.25 * spitForce + 0.5 * spitForce * (float)(rand() % 10) / 10.0);
        forceY = fabs(movementX) * spitForce * (0.5 + 0.1 * (float)(rand() % 10) / 10.0);
        if (dx * movementX > 0)
        {
                forceY += 2 * fabs(movementX);
        }
        if (movementY != 0 && dx * movementX < 0)
        {
                forceY -= 4;
        }
}
void TForm1::cGlob::update(cBackground * & background, cPhysics * & physics, float timeStep)
{
        if (!globbing)
        {
                return;
        }
        // position
        int
                fx = background->getGroundIndex(x);
        // x
        x += forceX * timeStep / 1000.0;
        if (x < 0 || x > 1) globbing = false;
        // y
        y += forceY * timeStep / 1000.0;
        if (y < background->ground[fx]) globbing = false;
        forceY -= physics->gravity;
}
void TForm1::cGlob::draw(TImage * & image, float angleX)
{
        if (!globbing)
        {
                return;
        }
        float
                dx = cos(angleX) * (float)image->Width * 50.0 / 49.0,
                dy = (float)image->Height;
        int
                start = (1 - cos(angleX)) * image->Width / 2;
        image->Canvas->Brush->Color = clGreen;
        image->Canvas->Pen->Color = clGreen;
        image->Canvas->Ellipse(Rect(start + dx * (x - r), image->Height - dy * (y + r),
                start + dx * (x + r), image->Height - dy*(y - r)));
}
//---------------------------------------------------------------------------
TForm1::cBlood::cBlood()
{
        drawBlood = false;
        bloodForce = 3;
        nBloods = 150;
        bloodsX = 0;
        bloodsY = 0;
        forceX = 0;
        forceY = 0;
        bleeding = 0;
        init(nBloods, bloodForce);
}
TForm1::cBlood::~cBlood()
{
        clear();
}
void TForm1::cBlood::clear()
{
        delete [] bloodsX; bloodsX = 0;
        delete [] bloodsY; bloodsY = 0;
        delete [] forceX; forceX = 0;
        delete [] forceY; forceY = 0;
        delete [] bleeding; bleeding = 0;
}
void TForm1::cBlood::init(int anBloods, float abloodForce)
{
        clear();
        bloodForce = abloodForce;
        nBloods = anBloods;
        bloodsX = new float[nBloods];
        bloodsY = new float[nBloods];
        forceX = new float[nBloods];
        forceY = new float[nBloods];
        bleeding = new bool[nBloods];
        for (int i = 0; i < nBloods; i++)
        {
                bleeding[i] = false;
        }
}
void TForm1::cBlood::start(bool right, float sx, float sy)
{
        drawBlood = true;
        if (right) dx = 1;
        else dx = -1;
        for (int i = 0; i < nBloods; i++)
        {
                bleeding[i] = true;
                bloodsX[i] = sx;
                bloodsY[i] = sy;
                forceX[i] = dx * bloodForce * (-0.3 + (float)(rand() % 100) / 100.0);
                forceY[i] = bloodForce * (float)(rand() % 100) / 100.0;
        }
}
void TForm1::cBlood::update(cBackground * & background,
        cPhysics * & physics, float timeStep)
{
        bool
                dropped = true;
        for (int i = 0; i < nBloods; i++)
        {
                if (!bleeding[i])
                {
                        continue;
                }
                dropped = false;
                // x
                bloodsX[i] += forceX[i] * timeStep / 1000.0;
                if (bloodsX[i] < 0 || bloodsX[i] > 1) bleeding[i] = false;
                // y
                int
                        fx = background->getGroundIndex(bloodsX[i]);
                bloodsY[i] += forceY[i] * timeStep / 1000.0;
                if (bloodsY[i] <= background->ground[fx])
                {
                        bleeding[i] = false;
                }
                forceY[i] -= physics->gravity;
        }
        if (dropped)
        {
                drawBlood = false;
        }
}
void TForm1::cBlood::draw(TImage * & image, float angleX)
{
        if (!drawBlood)
        {
                return;
        }
        float
                dx = cos(angleX) * (float)image->Width * 50.0 / 49.0,
                dy = (float)image->Height;
        int
                start = (1 - cos(angleX)) * image->Width / 2;
        for (int i = 0; i < nBloods; i++)
        {
                image->Canvas->Brush->Color = clRed;
                image->Canvas->Pen->Color = clRed;
                image->Canvas->Ellipse(Rect(start + dx * (bloodsX[i] - 0.003), image->Height - dy * (bloodsY[i] + 0.003),
                        start + dx * (bloodsX[i] + 0.003), image->Height - dy * (bloodsY[i] - 0.003)));
        }
}
//---------------------------------------------------------------------------
TForm1::cPhysics::cPhysics()
{
        gravity = 0.1;
}
TForm1::cPhysics::~cPhysics()
{
}
//---------------------------------------------------------------------------
TForm1::cGame::cGame()
{
        background = 0;
        physics = 0;
        figure1 = 0;
        figure2 = 0;
        glob1 = 0;
        glob2 = 0;
        blood = 0;
        bigBlood = 0;
        bgImage = 0;
        angleX = 0;
        init();
}
TForm1::cGame::~cGame()
{
        delete background;
        delete physics;
        delete figure1;
        delete figure2;
        delete glob1;
        delete glob2;
        delete blood;
        delete bigBlood;
}
void TForm1::cGame::init()
{
        clear();
        figure1Hit = false;
        figure2Hit = false;
        ending = false;
        if (background == 0)
        {
                background = new cBackground;
        }
        background->init();
        physics = new cPhysics;
        figure1 = new cFigure;
        figure1->init(1, 0.2, 1);
        figure2 = new cFigure;
        figure2->init(2, 0.8, 1);
        glob1 = new cGlob;
        glob1->init();
        glob2 = new cGlob;
        glob2->init();
        blood = new cBlood;
        blood->init(50, 3);
        bigBlood = new cBlood;
        bigBlood->init(250, 2);
}
void TForm1::cGame::clear()
{
//        delete background; background = 0;
        delete physics; physics = 0;
        delete figure1; figure1 = 0;
        delete figure2; figure2 = 0;
}
void TForm1::cGame::update(TImage * & image, float timeStep)
{
        // rotation during death time
        if (ending)
        {
                angleX += 0.1 * M_PI;
        }
        else
        {
                angleX = 0;
        }
        // figure
        figure1Hit = false;
        figure2Hit = false;
        figure1->update(background, physics, timeStep);
        figure2->update(background, physics, timeStep);
        // glob
        glob1->update(background, physics, timeStep);
        glob2->update(background, physics, timeStep);
        // blood
        blood->update(background, physics, timeStep);
        bigBlood->update(background, physics, timeStep);
        // hit
        if (glob2->globbing && figure1->x < glob2->x && figure1->x + figure1->w > glob2->x &&
                figure1->y < glob2->y && figure1->y + figure1->h > glob2->y)
        {
                glob2->globbing = false;
                figure1->health--;
                figure1Hit = true;
                blood->start(figure1->x > figure2->x, glob2->x, glob2->y);
        }
        if (glob1->globbing && figure2->x < glob1->x && figure2->x + figure2->w > glob1->x &&
                figure2->y < glob1->y && figure2->y + figure2->h > glob1->y)
        {
                glob1->globbing = false;
                figure2->health--;
                figure2Hit = true;
                blood->start(figure2->x > figure1->x, glob1->x, glob1->y);
        }
        draw(image);
}
void TForm1::cGame::draw(TImage * & image)
{
        clear(image);
        if (bgImage != 0)
        {
                image->Canvas->Draw(0, 0, bgImage);
        }
        background->draw(image, angleX);
        if (figure1->health <= 0)
        {
                figure1->draw(image, angleX);
                figure2->draw(image, angleX);
        }
        else
        {
                figure2->draw(image, angleX);
                figure1->draw(image, angleX);
        }
        glob1->draw(image, angleX);
        glob2->draw(image, angleX);
        blood->draw(image, angleX);
        bigBlood->draw(image, angleX);
        image->Repaint();
}
void TForm1::cGame::clear(TImage * & image)
{
        image->Canvas->Brush->Color = clWhite;
        image->Canvas->FillRect(Rect(0, 0, image->Width, image->Height));
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Edit1KeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
        char
                c = Key;
        parse(c);
        Edit1->Text = "";
        Edit1->Repaint();
}
void __fastcall TForm1::pulseTimer(TObject *Sender)
{
        pulse->Interval = 10;
        game->update(Image1, pulse->Interval);
        //sounds that are not started in parse
        if (game->figure1Hit)
        {
                hit1Wav->Rewind();
                hit1Wav->Play();
                if (game->figure1->health == 3)
                {
                        heartWav->Rewind();
                        heartWav->Play();
                }
        }
        if (game->figure2Hit)
        {
                hit2Wav->Rewind();
                hit2Wav->Play();
                if (game->figure2->health == 3)
                {
                        heartWav->Rewind();
                        heartWav->Play();
                }
        }
        //endgame
        if (!game->ending && game->figure1->health <= 0)
        {
                deathWav->Rewind();
                deathWav->Play();
                game->bigBlood->start(game->figure1->x > game->figure2->x, game->glob2->x, game->glob2->y);
                game->ending = true;
        }
        if (!game->ending && game->figure2->health <= 0)
        {
                deathWav->Rewind();
                deathWav->Play();
                game->bigBlood->start(game->figure2->x > game->figure1->x, game->glob1->x, game->glob1->y);
                game->ending = true;
        }
        if (game->ending)
        {
                pulse->Interval = 100;
                bool
                        dropped = true;
                for (int i = 0; i < game->bigBlood->nBloods; i++)
                {
                        if (game->bigBlood->bleeding[i])
                        {
                                dropped = false;
                        }
                }
                if (dropped)
                {
                        game->init();
                }
        }
}
void __fastcall TForm1::FormCreate(TObject *Sender)
{
        game = new cGame;
        pulse->Enabled = true;
}
void TForm1::parse(char c)
{
        if (game->ending)
        {
                return;
        }
        if (c == 'w' || c == 'W')
        {
                game->figure1->jump(game->background);
        }
        if (c == 'a' || c == 'A')
        {
                game->figure1->move(false);
        }
        if (c == 'd' || c == 'D')
        {
                game->figure1->move(true);
        }
        if (c == 's' || c == 'S')
        {
                glob1Wav->Rewind();
                glob1Wav->Play();
                game->glob1->spit(game->figure1->x > game->figure2->x, game->figure1->forceX, game->figure1->forceY,
                        game->figure1->x + game->figure1->w / 2, game->figure1->y + game->figure1->h * 0.5);
        }
        if (c == 'i' || c == 'I')
        {
                game->figure2->jump(game->background);
        }
        if (c == 'j' || c == 'J')
        {
                game->figure2->move(false);
        }
        if (c == 'l' || c == 'L')
        {
                game->figure2->move(true);
        }
        if (c == 'k' || c == 'K')
        {
                glob2Wav->Rewind();
                glob2Wav->Play();
                game->glob2->spit(game->figure2->x > game->figure1->x, game->figure2->forceX, game->figure2->forceY,
                        game->figure2->x + game->figure2->w / 2, game->figure2->y + game->figure1->h * 0.5);
        }
        if (c == ' ')
        {
                if ((AI1->Enabled || AI->Enabled) && AI1->Enabled != AI->Enabled)
                {
                        AI1->Enabled = true;
                }
                else
                {
                        AI1->Enabled = false;
                }
                AI->Enabled = !AI->Enabled;
        }
        if (c == 'm' || c == 'M')
        {
                game->background->mountainFactor += 0.2;
                if (game->background->mountainFactor > 1)
                {
                        game->background->mountainFactor -= 1.2;
                }
                game->background->init();
        }
        if (c == 'p' || c == 'P')
        {
                pulse->Enabled = false;
                OpenDialog1->Title = "Select background bitmap";
                OpenDialog1->FileName = "*.bmp";
                if (OpenDialog1->Execute())
                {
                        delete game->bgImage;
                        game->bgImage = new Graphics::TBitmap;
                        game->bgImage->LoadFromFile(OpenDialog1->FileName);
                }
                pulse->Enabled = true;
        }
}

void __fastcall TForm1::AITimer(TObject *Sender)
{
        int
                die = rand() % 12;
        if (game->glob2->globbing)
        {
                die = rand() % 10;
        }
        if (!game->glob2->globbing && game->figure2->forceY > 0)
        {
                die = 8 + rand() % 3;
        }
        bool
                escape = false;
        if (game->figure2->x > 1 - 5 * game->figure2->w || game->figure2->x < 5 * game->figure2->w)
        {
                escape = true;
        }
        char
                c,
                towards,
                away;
        if (!escape == game->figure1->x < game->figure2->x)
        {
                towards = 'j';
                away = 'l';
        }
        else
        {
                towards = 'l';
                away = 'j';
        }
        if (game->figure2->forceY <= 0 && ((game->figure2->x + game->figure2->w) >= game->figure1->x) &&
                (game->figure2->x <= game->figure1->x + game->figure1->w))
        {
                if (AI1->Enabled)
                {
                        die = 9 * rand() % 2;
                }
                else
                {
                        die = 9;
                        int
                                die2 = rand() % 10;
                        if (die2 == 0)
                        {
                                die = 0;
                        }
                }
        }
        if (die >= 0 && die < 3) c = 'i';
        if (die >= 3 && die < 8) c = away;
        if (die >= 8 && die < 9) c = towards;
        if (die >= 9) c = 'k';
        parse(c);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::AI1Timer(TObject *Sender)
{
        int
                die = rand() % 12;
        char
                c,
                towards,
                away;
        if (game->figure1->x < game->figure2->x)
        {
                towards = 'd';
                away = 'a';
        }
        else
        {
                towards = 'a';
                away = 'd';
        }
        if (game->figure2->forceY <= 0 && ((game->figure2->x + game->figure2->w) >= game->figure1->x) &&
                (game->figure2->x <= game->figure1->x + game->figure1->w))
        {
                if (AI->Enabled)
                {
                        die = 5 + 2 * rand() % 2;
                }
                else
                {
                        die = 7;
                        int
                                die2 = rand() % 10;
                        if (die2 == 0)
                        {
                                die = 0;
                        }
                }
        }
        if (die >= 0 && die < 5) c = towards;
        if (die >= 5 && die < 6) c = away;
        if (die >= 6 && die < 7) c = 'w';
        if (die >= 7 && die < 12) c = 's';
        parse(c);
}
//---------------------------------------------------------------------------

