//---------------------------------------------------------------------------

#ifndef td5_Unit1H
#define td5_Unit1H
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <math.h>
#include <MPlayer.hpp>
#include <Dialogs.hpp>
//---------------------------------------------------------------------------
class TForm1 : public TForm
{
__published:	// IDE-managed Components
        TEdit *Edit1;
        TImage *Image1;
        TTimer *pulse;
        TLabel *Label1;
        TTimer *AI;
        TMediaPlayer *glob1Wav;
        TMediaPlayer *hit1Wav;
        TMediaPlayer *deathWav;
        TMediaPlayer *hit2Wav;
        TMediaPlayer *glob2Wav;
        TMediaPlayer *heartWav;
        TTimer *AI1;
        TOpenDialog *OpenDialog1;
        TLabel *Label2;
        void __fastcall Edit1KeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
        void __fastcall pulseTimer(TObject *Sender);
        void __fastcall FormCreate(TObject *Sender);
        void __fastcall AITimer(TObject *Sender);
        void __fastcall AI1Timer(TObject *Sender);
private:	// User declarations
public:		// User declarations
        __fastcall TForm1(TComponent* Owner);
        class cBackground
        {
                public:
                        int
                                nGroundPoints;
                        float
                                width,
                                height,
                                groundBase,
                                groundSmoother,
                                *ground,
                                mountainFactor,
                                xAngle;
                        cBackground();
                        ~cBackground();
                        void draw(TImage * & image, float angleX);
                        void init();
                        void init(int anGroundPoints, float agroundBase, int agroundSmoother);
                        int getGroundIndex(float x);
        };
        class cPhysics
        {
                public:
                        cPhysics();
                        ~cPhysics();
                        float
                                gravity;
        };
        class cFigure
        {
                public:
                        cFigure();
                        ~cFigure();
                        float
                                x,
                                y,
                                w,
                                h,
                                forceX,
                                forceY,
                                moveStart,
                                jumpStart;
                        int
                                fignr,
                                health;
                        void init(int afignr, float ax, float ay);
                        void draw(TImage * & image, float angleX);
                        void update(cBackground * & background,
                                cPhysics * & physics, float timeStep);
                        void jump(cBackground * & background);
                        void move(bool right);
        };
        class cGlob
        {
                public:
                        cGlob();
                        ~cGlob();
                        float
                                x,
                                y,
                                r,
                                dx,
                                spitForce,
                                forceX,
                                forceY;
                        bool
                                globbing;
                        void init();
                        void spit(bool right, float movementX, float movementY, float ax, float ay);
                        void update(cBackground * & background,
                                cPhysics * & physics, float timeStep);
                        void draw(TImage * & image, float angleX);
        };
        class cBlood
        {
                public:
                        cBlood();
                        ~cBlood();
                        int
                                nBloods;
                        float
                                dx,
                                bloodForce,
                                *forceX,
                                *forceY,
                                *bloodsX,
                                *bloodsY;
                        bool
                                drawBlood,
                                *bleeding;
                        void clear();
                        void init(int anBloods, float abloodForce);
                        void start(bool right, float sx, float sy);
                        void update(cBackground * & background,
                                cPhysics * & physics, float timeStep);
                        void draw(TImage * & image, float angleX);
        };
        class cGame
        {
                public:
                        cGame();
                        ~cGame();
                        Graphics::TBitmap
                                *bgImage;
                        cFigure
                                *figure1,
                                *figure2;
                        cGlob
                                *glob1,
                                *glob2;
                        cBlood
                                *blood,
                                *bigBlood;
                        cBackground
                                *background;
                        cPhysics
                                *physics;
                        bool
                                figure1Hit,
                                figure2Hit,
                                ending;
                        float
                                angleX;
                        void update(TImage * & image, float timeStep);
                        void draw(TImage * & image);
                        void init();
                        void clear();
                        void clear(TImage * & image);
        };
        cGame
                *game;
        void parse(char c);
};
//---------------------------------------------------------------------------
extern PACKAGE TForm1 *Form1;
//---------------------------------------------------------------------------
#endif
